/*
Program : Strip (Secure Tool for Recalling Important Passwords) 
Description: A secure password and account manager for the Palm(t) Computing Platform 
Copyright (C) 1999  Stephen J Lombardo

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

Strip has been written and developed by Stephen J Lombardo (Zetetic Enterprises) 1999

Contact Info:
lombardos@zetetic.net
http://www.zetetic.net/
Zetetic Enterprises
348 Wasington Ave 
Clifton NJ, 07011

Bug reports and feature requests should be sent to bugs@zetetic.net.


------RSA Data Security, Inc. MD5 Message Digest Algorithm-------------
Strip uses the MD5 message digest algorithm, Copyright (C) 1990, 
RSA Data Security, Inc. All rights reserved. See md5.c or md5.h 
for specific terms and warranty disclaimer from RSA Data Security Inc.
-----------------------------------------------------------------------

------Three-way block encryption---------------------------------------
Strip uses the 3-Way block encryption algoritm, Copyright (C) Joan 
Daemen. All rights reserved.
-----------------------------------------------------------------------

        <**  DO NOT EXPORT **>
Strip uses strong cryptography. "3-way" is a block algoritm with a
96 bit key length, and "MD5" creates a 128 bit message digest. In the 
United states it is currently illegal to export products describing
or incorporating encryption techniques with key lengths greater
than 40 bits. It is therefore illegal to export this program in
any format. Please dont get the government on my back...
*/                 
#define StripCreator 'SJLO'
#define passwordDBType 'Pass'
#define passwordDBName "StripPassword-SJLO"
#define systemDBType 'Syst'
#define systemDBName "StripSystems-SJLO"
#define accountDBType 'Acct'
#define accountDBName "StripAccounts-SJLO"

typedef struct
{
    UInt SystemID;
    char   *name;
} System;

typedef struct
{
    UInt SystemID;
    char name[1];
} PSystem;



typedef struct
{
    UInt SystemID;
    UInt AccountID;
    char   *username;
    char   *password;
    char   *type;
    char   *comment;
} Account;

typedef struct
{
    UInt SystemID;
    UInt AccountID;
    char  username[1];
} PAccount;


typedef VoidPtr  RecordBuffer ;
typedef VoidHand RecBuff;


typedef char mdKey[16];



static Boolean PasswordHandleEvent(EventPtr );
static Err StartApplication();
static Err getDatabase(DmOpenRef *, ULong , ULong , ULong , UInt , char *, Boolean *);
static FieldPtr GetFocusObjectPtr();
static FieldPtr setFieldFromHandle(Word , VoidHand );
static FieldPtr setFieldFromString(Word , CharPtr );

static UInt getAccountSizeA(Account *, Boolean, int );
static UInt getSystemSizeA(System *, int);

static VoidPtr GetObjectFromActiveForm(Word );
static Word DisplayAboutBox();
static Word DisplayInfoBox();

static void DrawCharsToFitWidth(char *, RectanglePtr );
static void EventLoop();
static void HandleClickInPopup(EventPtr );

static void PackAccountA(RecordBuffer , Account , char * , Boolean , int); 
static void PackPasswordA(RecordBuffer , char *, int );
static void PackSystemA(RecordBuffer  , System , char * , Boolean , int);

static void StopApplication();


static void UnpackAccountA(Account * , RecordBuffer  , RecordBuffer  , char * , UInt , Boolean , Boolean, int );
static void UnpackPasswordA(RecordBuffer , RecordBuffer , char * ,int);
static void UnpackSystemA(System * , RecordBuffer  , RecordBuffer  , char * , UInt , Boolean , int);

static void addAccount(UInt , RecordBuffer , VoidHand );
static void addPassword(RecordBuffer , VoidHand );
static void addSystem(RecordBuffer , VoidHand );

static void changeForm(Word );

static void checkPassword();



