/*
Program : Strip (Secure Tool for Recalling Important Passwords) 
Description: A secure password and account manager for the Palm(t) Computing Platform 
Copyright (C) 1999  Stephen J Lombardo

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

Strip has been written and developed by Stephen J Lombardo (Zetetic Enterprises) 1999

Contact Info:
lombardos@zetetic.net
http://www.zetetic.net/
Zetetic Enterprises
348 Wasington Ave 
Clifton NJ, 07011

Bug reports and feature requests should be sent to bugs@zetetic.net.


------RSA Data Security, Inc. MD5 Message Digest Algorithm-------------
Strip uses the MD5 message digest algorithm, Copyright (C) 1990, 
RSA Data Security, Inc. All rights reserved. See md5.c or md5.h 
for specific terms and warranty disclaimer from RSA Data Security Inc.
-----------------------------------------------------------------------

------Three-way block encryption---------------------------------------
Strip uses the 3-Way block encryption algoritm, Copyright (C) Joan 
Daemen. All rights reserved.
-----------------------------------------------------------------------

        <**  DO NOT EXPORT **>
Strip uses strong cryptography. "3-way" is a block algoritm with a
96 bit key length, and "MD5" creates a 128 bit message digest. In the 
United states it is currently illegal to export products describing
or incorporating encryption techniques with key lengths greater
than 40 bits. It is therefore illegal to export this program in
any format. Please dont get the government on my back...
*/

#define BLOCK 12
#define StripCreator 'SJLO'
#define passwordDBType 'Pass'
#define passwordDBName "StripPassword-SJLO"
#define systemDBType 'Syst'
#define systemDBName "StripSystems-SJLO"
#define accountDBType 'Acct'
#define accountDBName "StripAccounts-SJLO"

typedef struct
{
    UInt SystemID;
    char   *name;
} System;

typedef struct
{
    UInt SystemID;
    char name[1];
} PSystem;



typedef struct
{
    UInt SystemID;
    UInt AccountID;
    char   *username;
    char   *password;
    char   *type;
    char   *comment;
} Account;

typedef struct
{
    UInt SystemID;
    UInt AccountID;
    char  username[1];
} PAccount;


typedef VoidPtr  RecordBuffer ;
typedef VoidHand RecBuff;


typedef char mdKey[16];


static Boolean AccountFormHandleEvent(EventPtr );
static Boolean ApplicationHandleEvent(EventPtr );
static Boolean ChangePasswordHandleEvent(EventPtr );
static Boolean EditCommentHandleEvent(EventPtr );
static Boolean HandleCommonMenus(Word );
static Boolean PasswordHandleEvent(EventPtr );
static Boolean SystemFormHandleEvent(EventPtr );
static Boolean editAccountHandleEvent(EventPtr );
static Boolean EditSystemHandleEvent(EventPtr );
static Boolean newAccountHandleEvent(EventPtr );
static Boolean showAccountHandleEvent(EventPtr );
static Err BeamStream(ExgSocketPtr , RecordBuffer , ULong );
static Err ReadBytesIntoAccount(DmOpenRef , ExgSocketPtr , ULong , UInt , Boolean );
static Err RecieveBeamStream(DmOpenRef , ExgSocketPtr , Boolean );
static Err StartApplication();
static Err getDatabase(DmOpenRef *, ULong , ULong , ULong , UInt , char *, Boolean *);
static FieldPtr GetFocusObjectPtr();
static FieldPtr setFieldFromHandle(Word , VoidHand );
static FieldPtr setFieldFromString(Word , CharPtr );
static Int SortPosAccountFunction(Account *, RecordBuffer , Int , SortRecordInfoPtr , SortRecordInfoPtr, VoidHand);
static Int SortPosSystemFunction(System *, RecordBuffer , Int , SortRecordInfoPtr , SortRecordInfoPtr, VoidHand);
static UInt getAIDForAccountIndex(UInt );
static UInt getSIDForSystemIndex(UInt );
static UInt UnpackSIDFromSystem(RecordBuffer  , RecordBuffer  , char * , Boolean );
static UInt getAccountSize(Account *, Boolean );
static UInt getIndexOfNthAcct(UInt );
static UInt getSIDFromAccountIndex(UInt );
static UInt getSIDFromSystemIndex(UInt , RecBuff );
static UInt getSystemSize(System *);
static UInt getUniqueAccountID();
static UInt getUniqueSystemID();
static UInt numAccountsInSystem(UInt );
static VoidPtr GetObjectFromActiveForm(Word );
static Word DisplayAboutBox();
static Word DisplayInfoBox();
static void AccountFormInit();
static void AccountListDrawFunction(UInt , RectanglePtr , CharPtr *);
static void BeamAccount(UInt );
static void DrawCharsToFitWidth(char *, RectanglePtr );
static void EventLoop();
static void HandleClickInPopup(EventPtr );
static void HandlePowerOff(EventPtr);
static void PackAccount(RecordBuffer , Account , char * , Boolean );
static void PackPassword(RecordBuffer , char * );
static void PackSystem(RecordBuffer  , System , char * , Boolean );
static void PageScroll(DirectionType , Word , Word );
static void ScrollLines(int , Boolean , Word , Word );
static void SelectSystemInit();
static void SetAttributes(Word , Word , Word , Boolean, Word );
static void StopApplication();
static void SystemFormInit();
static void SystemListDrawFunction(UInt , RectanglePtr , CharPtr *);
static void UnpackAccount(Account * , RecordBuffer  , RecordBuffer  , char * , UInt , Boolean , Boolean );
static void UnpackPassword(RecordBuffer , RecordBuffer , char * );
static void UnpackSystem(System * , RecordBuffer  , RecordBuffer  , char * , UInt , Boolean );
static void UpdateScrollbar(Word , Word );
static void WriteAccountInfoToScreen();
static void WriteEditableAccountInfoToScreen();
static void WriteEditableSystemInfoToScreen();
static void WriteSystemToAccountForm();
static void addAccount(UInt , RecordBuffer , VoidHand );
static void addPassword(RecordBuffer , VoidHand );
static void addSystem(RecordBuffer , VoidHand );
static void cacheAccount(UInt );
static void cacheSystem(UInt );
static void changeForm(Word );
static void changePassword();
static void checkPassword();
static void clearTextField(Word );
static void createNewAccount();
static void createNewSystem();
static void deleteAccountFromDB();
static void deleteSystemFromDB();
static void editAccount();
static void editComment(Word );
static void editSystem();
static void encryptPlainAccounts();
static void freeCache();
static void freeCurAcc();
static void getAccountFromIndex(UInt , RecBuff , Account * );
static void getSystemFromIndex(UInt , RecBuff , System * );
static void initPassword(char * );
static void initSystems();
static void showAccountForm(UInt );
static void showComment();
static void showCreateAccountForm();
static void showEditAccountForm();
static void showShowAccount(UInt );
static void hideNoteButton();
static void showNoteButton();
static void generatePw(Word);
static void generatePasswordString(Word, Int, Int);
static Boolean generatePasswordHandleEvent(EventPtr );

