/* -- AIX/6000 System monitor 
**
**     print_nfsstat.c
**
** Copyright (c) 1991-1995 Jussi Maki, All Rights Reserved.
** Copyright (c) 1993-2001 Marcel Mol, All Rights Reserved.
** NON-COMMERCIAL USE ALLOWED. YOU ARE FREE TO DISTRIBUTE
** THIS PROGRAM AND MODIFY IT AS LONG AS YOU KEEP ORIGINAL
** COPYRIGHTS.
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <curses.h>
#include "config.h"
#include "get_nfsstat.h"
#include "print_nfsstat.h"
#include "print.h"

extern FILE *logfp;

#define NFSclD(a) (nfs1->clstat.a - nfs2->clstat.a)
#define NFSsvD(a) (nfs1->svstat.a - nfs2->svstat.a)
#define NFSRATE(a) NFSclD(a) / refresh_time, NFSsvD(a) / refresh_time

/***************************************************************************
 *                      PRINTING FUNCTIONS                                 *
 ***************************************************************************/

void
print_nfsstat_init()
{
    int x, y;

    x = 29 + 14; y = 15;

    BOLDON;
    move(y + 0, x - 14); printw("Client Server NFS/s");
    BOLDOFF;
    NAMECOLON;
    move(y + 1, x); printw("calls");
    move(y + 2, x); printw("retry");
    move(y + 3, x); printw("getattr");
    move(y + 4, x); printw("lookup");
    move(y + 5, x); printw("read");
    move(y + 6, x); printw("write");
    move(y + 7, x); printw("other\n");
    NAMECOLOFF;

    return;

} /* print_nfsstat_init */



void
print_nfsstat(double refresh_time, t_nfs_stats *nfs1, t_nfs_stats *nfs2)
{
    int x, y, client_other, server_other;

    x = 29; y = 15;
    move(y + 1, x); printw("%6.1f %6.1f", NFSRATE(ncalls));
    move(y + 2, x); printw("%6.1f %6.1f", (nfs1->rcstat.rcretrans -
                                           nfs2->rcstat.rcretrans) /
                                           refresh_time, 0);
    move(y + 3, x); printw("%6.1f %6.1f", NFSRATE(reqs[RFS_GETATTR]));
    move(y + 4, x); printw("%6.1f %6.1f", NFSRATE(reqs[RFS_LOOKUP]));
    move(y + 5, x); printw("%6.1f %6.1f", NFSRATE(reqs[RFS_READ]));
    move(y + 6, x); printw("%6.1f %6.1f", NFSRATE(reqs[RFS_WRITE]));
    client_other = NFSclD(reqs[RFS_NULL])
                 + NFSclD(reqs[RFS_SETATTR])
                 + NFSclD(reqs[RFS_ROOT])
                 + NFSclD(reqs[RFS_READLINK])
                 + NFSclD(reqs[RFS_WRITECACHE])
                 + NFSclD(reqs[RFS_CREATE])
                 + NFSclD(reqs[RFS_REMOVE])
                 + NFSclD(reqs[RFS_RENAME])
                 + NFSclD(reqs[RFS_LINK])
                 + NFSclD(reqs[RFS_SYMLINK])
                 + NFSclD(reqs[RFS_MKDIR])
                 + NFSclD(reqs[RFS_RMDIR])
                 + NFSclD(reqs[RFS_READDIR])
                 + NFSclD(reqs[RFS_STATFS])
                 + NFSclD(reqs[RFS_NPROC]);

    server_other = NFSsvD(reqs[RFS_NULL])
                 + NFSsvD(reqs[RFS_SETATTR])
                 + NFSsvD(reqs[RFS_ROOT])
                 + NFSsvD(reqs[RFS_READLINK])
                 + NFSsvD(reqs[RFS_WRITECACHE])
                 + NFSsvD(reqs[RFS_CREATE])
                 + NFSsvD(reqs[RFS_REMOVE])
                 + NFSsvD(reqs[RFS_RENAME])
                 + NFSsvD(reqs[RFS_LINK])
                 + NFSsvD(reqs[RFS_SYMLINK])
                 + NFSsvD(reqs[RFS_MKDIR])
                 + NFSsvD(reqs[RFS_RMDIR])
                 + NFSsvD(reqs[RFS_READDIR])
                 + NFSsvD(reqs[RFS_STATFS])
                 + NFSsvD(reqs[RFS_NPROC]);
    move(y + 7, x); printw("%6.1f %6.1f", client_other / refresh_time,
                                          server_other / refresh_time);

    return;

} /* print_nfsstat */



void
log_nfsstat_header()
{

    /* Nothing yet */
    fprintf(logfp, "# nfs_server[_max] calls badcalls null getattr"
                   " setattr root lookup readlink read writecache write"
                   " create remove rename link symlink mkdir rmdir readdir"
                   " statfs nproc <unknowns> (calls/second)\n");
    fprintf(logfp, "# nfs_client[_max] ncalls nbadcalls nclsleeps nclgets"
                   " null getattr setattr root lookup readlink read writecache"
                   " write create remove rename link symlink mkdir rmdir readdir"
                   " statfs nproc <unknowns> (calls/second)\n");

    fprintf(logfp, "# nfs_rpc_server[_max] calls badcalls nullrecv badlen"
                   " xdrcall (calls/second)\n");
    fprintf(logfp, "# nfs_rpc_client[_max] calls badcalls retransmits badxids"
                   " timeouts wait newcred badverf timers (calls/second)\n");

    return;

} /* log_nfsstat_header */



void
calc_nfsstat(double refresh_time, t_nfs_stats *nfs1, t_nfs_stats *nfs2)
{


    /* Nothing yet */

    return;

} /* calc_nfsstat */



void
log_nfsstat(double refresh_time, t_nfs_stats *nfs1, t_nfs_stats *nfs2)
{
    int i;

    /*
     * Define macros to calculate calls per second for each structure
     */
#define Nc(a) (nfs1->clstat.a - nfs2->clstat.a) / refresh_time
#define Ns(a) (nfs1->svstat.a - nfs2->svstat.a) / refresh_time
#define Rc(a) (nfs1->rcstat.a - nfs2->rcstat.a) / refresh_time
#define Rs(a) (nfs1->rsstat.a - nfs2->rsstat.a) / refresh_time


    fprintf(logfp, "nfs_server %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f",
                   Ns(ncalls), Ns(nbadcalls), Ns(reqs[RFS_NULL]),
                   Ns(reqs[RFS_GETATTR]), Ns(reqs[RFS_SETATTR]), Ns(reqs[RFS_ROOT]),
                   Ns(reqs[RFS_LOOKUP]), Ns(reqs[RFS_READLINK]), Ns(reqs[RFS_READ]),
                   Ns(reqs[RFS_WRITECACHE]), Ns(reqs[RFS_WRITE]),
                   Ns(reqs[RFS_CREATE]), Ns(reqs[RFS_REMOVE]), Ns(reqs[RFS_RENAME]),
                   Ns(reqs[RFS_LINK]), Ns(reqs[RFS_SYMLINK]), Ns(reqs[RFS_MKDIR]),
                   Ns(reqs[RFS_RMDIR]), Ns(reqs[RFS_READDIR]), Ns(reqs[RFS_STATFS]),
                   Ns(reqs[RFS_NPROC]));
    for (i = RFS_NPROC + 1; i < 32; i++) {
        fprintf(logfp, " %.1f", Ns(reqs[i]));
    }
    putc('\n', logfp);

    fprintf(logfp, "nfs_client %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f",
                   Nc(ncalls), Nc(nbadcalls), Nc(nclsleeps), Nc(nclgets),
                   Nc(reqs[RFS_NULL]), Nc(reqs[RFS_GETATTR]), Nc(reqs[RFS_SETATTR]),
                   Nc(reqs[RFS_ROOT]), Nc(reqs[RFS_LOOKUP]), Nc(reqs[RFS_READLINK]),
                   Nc(reqs[RFS_READ]), Nc(reqs[RFS_WRITECACHE]), Nc(reqs[RFS_WRITE]),
                   Nc(reqs[RFS_CREATE]), Nc(reqs[RFS_REMOVE]), Nc(reqs[RFS_RENAME]),
                   Nc(reqs[RFS_LINK]), Nc(reqs[RFS_SYMLINK]), Nc(reqs[RFS_MKDIR]),
                   Nc(reqs[RFS_RMDIR]), Nc(reqs[RFS_READDIR]), Nc(reqs[RFS_STATFS]),
                   Nc(reqs[RFS_NPROC]));
    for (i = RFS_NPROC + 1; i < 32; i++) {
        fprintf(logfp, " %.1f", Nc(reqs[i]));
    }
    putc('\n', logfp);



    fprintf(logfp, "nfs_rpc_server %.1f %.1f %.1f %.1f %.1f\n",
                   Rs(rscalls), Rs(rsbadcalls), Rs(rsnullrecv),
                   Rs(rsbadlen), Rs(rsxdrcall));
    fprintf(logfp, "nfs_rpc_client %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f %.1f\n",
                   Rc(rccalls), Rc(rcbadcalls), Rc(rcretrans), Rc(rcbadxids),
                   Rc(rctimeouts), Rc(rcwaits), Rc(rcnewcreds), Rc(rcbadverfs),
                   Rc(rctimers));

    fflush(logfp);

    return;

} /* log_nfsstat */



void
log_nfsstat_max()
{

    /* Nothing yet */

     /* fflush(logfp); */

    return;

} /* log_nfsstat_max */



void
max_nfsstat_init()
{

    /* Nothing yet */

    return;

} /* max_nfsstat_init */
