/* -- AIX/6000 System monitor 
**
**     print_afsstat.c
**
** Copyright (c) 1993-2001 Marcel Mol, All Rights Reserved.
** NON-COMMERCIAL USE ALLOWED. YOU ARE FREE TO DISTRIBUTE
** THIS PROGRAM AND MODIFY IT AS LONG AS YOU KEEP ORIGINAL
** COPYRIGHTS.
*/

#if defined(HAVE_AFS)

#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <curses.h>
#include "config.h"
#include "get_afsstat.h"
#include "print_afsstat.h"
#include "print.h"

extern FILE *logfp;

#define AFS_D(T)      (afs1->T - afs2->T)
#define AFS_P(T1, T2) ((T2) ? (100*(T1)/(double)(T2)) : 0)
#define AFS_T(a, b)   (afs1->a + afs1->b - afs2->a - afs2->b)
#define AFSRATE(T)    AFS_D(T) / refresh_time


/***************************************************************************
 *                      PRINTING FUNCTIONS                                 *
 ***************************************************************************/

void
print_afsstat_init()
{
    int x, y;

    x = 29 + 12; y = 15;

    BOLDON;
    move(y + 0, x - 12); printw("Client Server AFS/s");
    BOLDOFF;
    NAMECOLON;
    move(y + 1, x); printw("Packets");
    move(y + 2, x); printw("DRead");
    move(y + 3, x); printw("Lookup");
    move(y + 4, x); printw("GetVCache");
    move(y + 5, x); printw("GetDCache");
    move(y + 6, x); printw("Cache-Acc");
    move(y + 7, x); printw("CacheHit\n");
    NAMECOLOFF;

    return;

} /* print_afsstat_init */



void
print_afsstat(double refresh_time, afsstat_t *afs1, afsstat_t *afs2)
{
    int x, y;

    x = 29; y = 15;

    move(y + 1, x); printw("%5.0f %5.1f",   AFSRATE(packetRequests), 0);
    move(y + 2, x); printw("%5.0f %5.1f",   AFSRATE(DRead)         , 0);
    move(y + 3, x); printw("%5.0f %5.1f",   AFSRATE(lookup)        , 0);
    move(y + 4, x); printw("%5.0f %5.1f",   AFSRATE(GetVCache)     , 0);
    move(y + 5, x); printw("%5.0f %5.1f",   AFSRATE(GetDCache)     , 0);
    move(y + 6, x); printw("%5.0f %5.1f",   AFSRATE(cacheAccess)   , 0);
    move(y + 7, x); printw("%4.0f%% %5.1f", AFS_P(AFS_D(cacheHits),
                                                  AFS_D(cacheAccess)), 0);

    return;

} /* print_afsstat */



void
log_afsstat_header()
{

    /* Nothing yet */

    return;

} /* log_afsstat_header */



void
calc_afsstat(double refresh_time, afsstat_t *afs1, afsstat_t *afs2)
{

    /* Nothing yet */

    return;

} /* calc_afsstat */



void
log_afsstat(double refresh_time, afsstat_t *afs1, afsstat_t *afs2)
{

    /* Nothing yet */

    fflush(logfp);

    return;

} /* log_afsstat */



void
log_afsstat_max()
{

    /* Nothing yet */

    fflush(logfp);

    return;

} /* log_afsstat_max */



void
max_afsstat_init()
{

    /* Nothing yet */

    return;

} /* max_afsstat_init */

#endif /* HAVE_AFS */
