/* -- AIX/6000 System monitor 
**
**     monitor.h
**
** Copyright (c) 1991-1995 Jussi Maki, All Rights Reserved.
** Copyright (c) 1993-2001 Marcel Mol, All Rights Reserved.
** NON-COMMERCIAL USE ALLOWED. YOU ARE FREE TO DISTRIBUTE
** THIS PROGRAM AND MODIFY IT AS LONG AS YOU KEEP ORIGINAL
** COPYRIGHTS.
*/

#include <curses.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <locale.h>

#include <sys/types.h>
#include <sys/select.h>
#include <unistd.h>
#include <fcntl.h>
#include <math.h>
#include <time.h>
#include <sys/time.h>
#include <sys/utsname.h>
#include <pwd.h>
#include <stdarg.h>


#include "get_dkstat.h"
#include "get_ifnet.h"
#include "get_nfsstat.h"
#include "get_afsstat.h"
#include "print_dkstat.h"
#include "print_ifnet.h"
#include "print_nfsstat.h"
#include "print_afsstat.h"
#include "getloadavg.h"
#include "get_odm.h"
#include "get_top.h"
#include "print_top.h"
#include "get_sysvminfo.h"
#include "get_cpuinfo.h"
#include "filesys.h"
#include "monprint.h"

#if defined(DEBUG)
#include "debug.h"
#endif

#define MONITOR_NAME "AIX Monitor v" MON_VERSION " " MON_DATE

#if !defined(AIX_VERSION)
# define AIX_VERSION 0
#endif
#if !defined(AIX_RELEASE)
# define AIX_RELEASE 0
#endif
#if !defined(AIX_LEVEL)
# define AIX_LEVEL 0
#endif
#if !defined(AIX_FIX)
# define AIX_FIX 0
#endif
#if !defined(AIX_NUM)
# define AIX_NUM  AIX_VERSION 0 AIX_RELEASE 0 AIX_LEVEL 0 AIX_FIX
#endif


#if !defined(HIGHLIGHT)
# define HIGHLIGHT 1
#endif

