/* -- AIX/6000 System monitor 
**
**     get_sysvminfo.c
**
** Copyright (c) 1991-1995 Jussi Maki, All Rights Reserved.
** Copyright (c) 1993-2001 Marcel Mol, All Rights Reserved.
** NON-COMMERCIAL USE ALLOWED. YOU ARE FREE TO DISTRIBUTE
** THIS PROGRAM AND MODIFY IT AS LONG AS YOU KEEP ORIGINAL
** COPYRIGHTS.
*/

#include <stdio.h>	/* for perror */
#include <nlist.h>
#include <sys/utsname.h>
#include "config.h"
#include "get_sysvminfo.h"
#include "getkmemdata.h"
#if AIX_NUM >= 4030300
# include <dlfcn.h>
#endif

typedef   void (*SimpleFunc) ();

#define N_VALUE(index) ((caddr_t)kernelnames[index].n_value)
#define KNSTRUCTS_CNT 3
#define NLIST_SYSINFO 0
#define NLIST_VMKER 1
#define NLIST_VMINFO 2
struct nlist kernelnames[] = {
    {"sysinfo", 0, 0, 0, 0, 0},
    {"vmker",   0, 0, 0, 0, 0},
    {"vmminfo", 0, 0, 0, 0, 0},
    {NULL,      0, 0, 0, 0, 0},
};

SimpleFunc my_vmgetinfo;

struct vmker42  *vmk42;
struct vmker43  *vmk43;
struct vmker433 *vmk433;

extern int aix_version;
extern int aix_release;
extern int aix_level;
extern int aix_fix;
extern int check_badmem;

extern char *progname;

int aix43;
/***************************************************************************
 *                      DATA CAPTURE FUNCTIONS                             *
 ***************************************************************************/

void
init_sys_vm()
{

#if AIX_NUM >= 4030300
    void * handle;
#endif

    if (knlist(kernelnames, KNSTRUCTS_CNT, sizeof(struct nlist)) == -1)
        perror("knlist, entry not found");

#if AIX_NUM >= 4030300
    vmk433 = (struct vmker433 *) malloc(sizeof(struct vmker433));
    /* 
     * Get the call address for the vmgetinfo system call
     */
    if ((handle = dlopen("/unix", RTLD_NOW | RTLD_GLOBAL)) == NULL) {
        fprintf(stderr, "%s: init_sys_vm: dlopen: can't load %s (%s)\n", 
                        progname, "/unix", dlerror());
        perror("dlopen");
        exit(1);
    }
    my_vmgetinfo = dlsym( handle, "vmgetinfo");
    dlclose(handle);
    if (my_vmgetinfo == NULL) {
        fprintf(stderr, "%s: init_sys_vm: dlsym: can't find %s (err %s)\n",
                        progname, "vmgetinfo", dlerror());
        perror("dlsym");
    }
#else
    aix43 = (aix_version == 4 && aix_release == 3) ? 1 : 0;
    if (aix43)
        vmk43 = (struct vmker43 *) malloc(sizeof(struct vmker43));
    else
        vmk42 = (struct vmker42 *) malloc(sizeof(struct vmker42));
#endif

    return;

} /* init_sys_vm */



void
get_sys_vm_info(struct sysinfo *si, struct vmker *vmk, struct vminfo *vm)
{

    getkmemdata(si,  sizeof(struct sysinfo), N_VALUE(NLIST_SYSINFO));
    /*
     * Get the system info structure from the running kernel.
     * Get the kernel virtual memory vmker structure
     * Get the kernel virtual memory info structure
     */
#if AIX_NUM >= 4030300
    my_vmgetinfo(vm, VMINFO, 1);
#else
    getkmemdata(vm,  sizeof(struct vminfo),  N_VALUE(NLIST_VMINFO));
#endif


#if AIX_NUM >= 4030300
     getkmemdata(vmk433, sizeof(struct vmker433),   N_VALUE(NLIST_VMKER));
     vmk->totalmem    = vmk433->totalmem;
     vmk->badmem      = vmk433->badmem;
     vmk->freemem     = vm->numfrb;
     vmk->maxperm     = vm->maxperm;
     vmk->numperm     = vm->numperm;
     vmk->totalvmem   = vmk433->totalvmem;
     vmk->freevmem    = vmk433->freevmem;
     vmk->nonpinnable = 0;
     vmk->numclient   = vm->numclient;
     vmk->maxclient   = vm->maxclient;
#else
    if (aix43) {
        getkmemdata(vmk43, sizeof(struct vmker43),   N_VALUE(NLIST_VMKER));
        vmk->totalmem    = vmk43->totalmem;
        vmk->badmem      = vmk43->badmem;
        vmk->freemem     = vmk43->freemem;
        vmk->maxperm     = vmk43->maxperm;
        vmk->numperm     = vmk43->numperm;
        vmk->totalvmem   = vmk43->totalvmem;
        vmk->freevmem    = vmk43->freevmem;
        vmk->nonpinnable = vmk43->nonpinnable;
        vmk->numclient   = vmk43->numclient;
        vmk->maxclient   = vmk43->maxclient;
    }
    else {
        getkmemdata(vmk42, sizeof(struct vmker42),   N_VALUE(NLIST_VMKER));
        vmk->totalmem    = vmk42->totalmem;
        vmk->badmem      = vmk42->badmem;
        vmk->freemem     = vmk42->freemem;
        vmk->maxperm     = vmk42->maxperm;
        vmk->numperm     = vmk42->numperm;
        vmk->totalvmem   = vmk42->totalvmem;
        vmk->freevmem    = vmk42->freevmem;
        vmk->nonpinnable = vmk42->nonpinnable;
        vmk->numclient   = vmk42->numclient;
        vmk->maxclient   = vmk42->maxclient;
    }
#endif

    if (vmk->badmem)
        vmk->badmem -= 16; /* adjust memory for 220 models? */
                           /* and also on C10 models */
                           /* does it have something to do with unused
                              SIMM slots ??? */
    
    if (check_badmem && vmk->badmem > 0)
        vmk->totalmem -= vmk->badmem;
#if 0
    /* 
     * 09jun1999, MM: can't see why this is needed...
     *                it breaks on systems with large memories.
     */
    /*
     * round the amount of memory to the nearest 4 MB, For one J series
     * machine the vmk->totalmem did not give a correct number
     */
    vmk->totalmem = (vmk->totalmem*4096/1024/1024+2)*4/4*1024/4096*1024;
    vmk->totalmem += 1023;
    vmk->totalmem /= 256;
    vmk->totalmem *= 256;
#endif

    return;

} /* get_sys_vm_info */

