/*
 *
 * ttx.c  --- Main program file for ttx
 *
 */

/*
 * ttx.c
 * Copyright (C) 1995,1996 M.F. van Loon <mfvl@xs4all.nl>,
 * Copyright (C) 2001-2003 Marcel .J.E. Mol <marcel@mesa.nl>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */


#undef  DEBUG
#undef  LOCAL
#undef  DEBUG_SMALL

#ifdef DEBUG
# define DEBUG_SMALL
#endif

#define VERSIE "2.4.6"

#include <stdio.h>
#include <sys/types.h>
#include <netdb.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include "sockextr.h"

#ifndef FALSE
# define FALSE (0)
# define TRUE (!FALSE)
#endif

#ifndef __EMX__
# define stricmp strcasecmp
# define strnicmp strncasecmp
#endif

#ifdef LOCAL
# define TTX_NODE       "localhost"
# define TTX_PORT       "80"
# define TTX_URL        "/cgi-bin/indexcgi.exe?"
#else
# define TTX_NODE       "teletekst.nos.nl"
# define TTX_PORT       "80"
# define TTX_URL        "/tekst/"
#endif

#define id         "TTX V" VERSIE " (C) 1995,1996 M.F. van Loon, 2001-2003 M.J.E. Mol\n"
#define USER_AGENT "User-Agent: TTX/" VERSIE " Text mode Teletext page retriever"
#define err_sock_print() perror("Cannot write to net\n")

int    repeat;
int    error = FALSE;
char   hostname[256];
char * port;
char   url[512];
static char buffer[40960];
struct tcp_socket *s;
int    in_header, pagcnt, subpage, in_pre;
int   do_color = 1;
int   do_raw   = 0;
char * c, * d, * e;
char * ttx_node, * ttx_url;
char * ttx_port;
char * progname;

char *color_table[] = { "black",
                      "red", 
                      "lime", 
                      "yellow", 
                      "blue", 
                      "fuchsia", 
                      "aqua", 
                      "white", 
                    };
#define MAXCOL 8

/*
 * Fnuction declarations
 */
char *strip_cr(char *b);
void usage();



int main(int argc, char **argv)
{
    int rc = 0;
    progname = *argv++;

    if (argc > 1) {
        if (!strncmp(*argv, "--nocol", 7)) {
            do_color = 0;
            argc--;
            argv++;
       }
       else if (!strncmp(*argv, "--raw", 5)) {
            do_raw = 1;
            argc--;
            argv++;
       }
       else if (!strncmp(*argv, "--help", 6) ||
                !strncmp(*argv, "-h", 2)) {
           usage();
           exit(0);
       }
       
    }

    fprintf(stderr, "%s\n", id);

    if (!(ttx_node = getenv("TTX_NODE")))
        ttx_node = TTX_NODE;
    if (!(ttx_port = getenv("TTX_PORT")))
        ttx_port = TTX_PORT;
    if (!(ttx_url = getenv("TTX_URL")))
        ttx_url = TTX_URL;


    sock_init();
    if(argc < 2) {
        for (subpage = 1; getpage("100", subpage); subpage++);
    }
    else {
        argc--;
        for (pagcnt = 0; pagcnt < argc; pagcnt++) {
            rc = 0;
            for (subpage = 1; rc == 0; subpage++) {
                rc  = getpage(argv[pagcnt], subpage);
#ifdef DEBUG_SMALL
                printf("getting subpage %d rc %d\n", subpage, rc);
#endif
            }
        }
    }

    close_socket(s);

    exit(0);

} /* main */



getpage(char * pagenum, int subpage) 
{
    strcpy(hostname, ttx_node);
    port = ttx_port;
    sprintf(url, "%s%s-%02d.html", ttx_url, pagenum, subpage);
#ifdef DEBUG_SMALL
    fprintf(stderr, "Pagina %s - %d\n", pagenum, subpage);
#endif

    do {
        if ((s = make_connection(hostname, port)) == NULL) {
            fprintf(stderr,"Can't connect to: %s, %s\n", hostname, port);
            return 1; 
        }
        if (sock_printf(s,"GET %s HTTP/1.0", url) < 0) {
            err_sock_print();
            return 1;
        }
        if (sock_printf(s, "%s", USER_AGENT) < 0) {
            err_sock_print();
            return 1;
        }
        if (sock_printf(s, "Host: %s:%s", hostname, port) < 0) {
            err_sock_print();
            return 1;
        }
        if (sock_printf(s, "Accept: */*") < 0) {
            err_sock_print();
            return 1;
        }
        if (sock_printf(s, "") < 0) {
            err_sock_print();
            return 1;
        }
#ifdef DEBUG_SMALL
        fprintf(stderr,"GET %s HTTP/1.0\n", url);
        fprintf(stderr,"%s\n", USER_AGENT);  
        fprintf("Host: %s:%s", hostname, port);
        fprintf(stderr,"\n");
#endif

        in_header = TRUE;
        in_pre = FALSE;
        repeat = FALSE;
        memset(buffer, 0, sizeof(buffer));
        while (sgets(buffer, sizeof(buffer) - 1, s) != NULL) {
            strip_cr(buffer);
#if defined( DEBUG)
            fprintf(stderr, "%4ld: %s\n", strlen(buffer), buffer);
#elif defined(DEBUG_SMALL)
            fprintf(stderr, "Size = %4ld\n", strlen(buffer));
#endif
            if (in_header) {
                if (buffer[0] == 0)
                    in_header = FALSE;
                else if (strnicmp(buffer, "HTTP/1.1 404 Not Found", 22) == 0)
                    return 1;
                else {
                    if (strnicmp(buffer, "Location:", 9) == 0) {
                        if ((c = strstr(buffer, "http://")) == NULL) {
                            if ((c = strchr(buffer, '/')) == NULL) {
                                fprintf(stderr, "Bad Location: %s\n", buffer);
                                error = TRUE;
                                repeat = FALSE;
                                return 1;
                            }
                            strcpy(url, c);
                        }
                        else {
                            c += 7;
                            d = strchr(c, ':');
                            e = strchr(c, '/');
                            if(d != NULL) {
                                if(d > e && e != NULL)
                                    d = NULL;
                            }
                            if(d != NULL) {
                                *d++ = 0;
                                port = d;
                            }
                            else
                                port = "80";
                            if(e != NULL) {
                                strcpy(url, e);
                                *e = 0;
                            }
                            else
                                *url = 0;
                            strcpy(hostname, c);
                        }
#ifdef DEBUG_SMALL
                        fprintf(stderr, "Na location: host = %s, port = %s, url = %s\n", hostname, port, url);
#endif
                        repeat = TRUE;
                    }
                }
            }
            else if (do_raw) {
                    printf("%s\n", buffer);
            }
            else {
                char * b = buffer;
                if ((c = strstr(b, "<pre>")) != NULL) {
                    in_pre = TRUE;
                    b = c + 5;
                }
                c = b;
                if (strstr(b, "</pre>") != NULL) {
                    in_pre = FALSE;
                }
                if (in_pre) {
                    while ((d = strchr(c, '<')) != NULL) {
                        if ((c = strchr(d, '>')) == NULL) {
                            fprintf(stderr, "error: no matching > found\n");
                            break;
                        }
                        else {
                            /*
                             * Check for COLOR 
                             */
                            if (do_color) {
                                if (!strnicmp(d+1, "FONT COLOR=", 11)) {
                                    char * f;
                                    long int col;
                                    int col2 = '0', foundcol = 0;
                                    for (col2 = 0; col2 < MAXCOL; col2++) {
                                        if (!strnicmp(d+12, color_table[col2], strlen(color_table[col2]))) {
                                            foundcol = 1;
                                            break;
                                        }
                                    }
                                    if (!foundcol) {
                                        col = strtol(d+12, &f, 16); 
                                        if (c != f)
                                            fprintf(stderr, "warning: font tag unknown\n");
                                        /* printf("col %06x ", col); */
                                        if (col & 0xff0000) col2 += 1;
                                        if (col & 0x00ff00) col2 += 2;
                                        if (col & 0x0000ff) col2 += 4;
                                    }
                                    /* printf("col %02d%c ", col2, foundcol ? 'a' : 'n'); */
                                    col2 += 0x30;
              
                                    *d++ = '\e';
                                    *d++ = '[';
                                    *d++ = '3';
                                    *d++ = col2;
                                    *d++ = ';';
                                    *d++ = '1';
                                    *d++ = 'm';
                                }
                                else if (!strnicmp(d+1, "/FONT>", 6)) {
                                    /* printf("col default "); */
                                    *d++ = '\e';
                                    *d++ = '[';
                                    *d++ = '0';
                                    *d++ = 'm';
                                }
                            }
                            
                            memmove(d, ++c, strlen(c)+1);
                            c = d;
                        }
                    }
                    c = b;
                    while ((d = strchr(c, '&')) != NULL) {
                        if ((c = strchr(d, ';')) == NULL) {
                            fprintf(stderr, "error: no matching ; found\n");
                            break;
                        }
                        else {
                            *c++ = '\0';
                            if (strcmp(d+1, "quot") == 0)
                                *d++ = '"';
                            else if (strcmp(d+1, "lt") == 0)
                                *d++ = '<';
                            else if (strcmp(d+1, "gt") == 0)
                                *d++ = '>';
                            else if (strcmp(d+1, "amp") == 0)
                                *d++ = '&';
                            else 
                                *d++ = '?';
                            memmove(d, c, strlen(c)+1);
                            c = d;
                        }
                    }
                    printf("%s\n", b);
                }
            }
        }
    } while (repeat);

    if (do_color) {
        printf("\e[0m");
    }
            
    return 0;

} /* getpage */



char *strip_cr(char *b)
{
    size_t len = strlen(b);

    while (len > 0 && strchr("\n\r \t",b[len-1]) != NULL)
        b[--len] = 0; 

    return b;

} /* strip_cr */



void usage()
{

    printf("TTX V%s (C) 1995,1996 M.F. van Loon, 2001-2003 M.J.E. Mol\n\n", VERSIE);
    printf("%s [--nocol|--help|-h] [<pagenumbers>]\n\n", progname);
    printf("    --nocol     do not use ansi color codes\n");
    printf("    --help      this help screen\n");
    printf("    --raw       do not process, but dump raw page data\n");
    printf("    -h          this help screen\n\n");

    return;
    
} /* usage */
